#include "Player.h"

using namespace std;

//Change game over state
void Player::setGameOver(bool value) {
	gameover = value;
}
//Check if game is over
bool Player::isGameOver() {
	return gameover;
}

//Check if a player has picked up a sword
void Player::setArmed(bool value) {
	armed = value;

}

//Returns if a player is armed
bool Player::isArmed() {
	return armed;
}

//Check if a player has picked up a shield
void Player::setProtected(bool value) {
	protect = value;
}

//Return if a player has picked up a shield 
bool Player::isProtect() {
	return protect;
}

//Return if a player has picked up the gem
void Player::setSpell(bool value) {
	spell = value;

}

//returns if a player 
bool Player::isSpell() {
	return spell;
}

//Get the inventory
void Player::getInventory()
{
	vector<string>::iterator iter;

	if (inventory.size() != 0)
	{
		cout << "\nInventory list:" << endl;
		for (iter = inventory.begin(); iter != inventory.end(); ++iter)
		{
			cout << *iter << endl;
		}
	}
	else
		cout << "\nInventory is empty!" << endl;
}

//Keep track of wher the player is 
Player::Player()
{
	pLoc = mStart;
}

//Move the character around the screen
void Player::move(string direction)
{
	char a = direction.at(0);
	string key;

	if (!pLoc->roomEnemy.empty()) {
		cout << "You cannot leave while you are being attacked." << endl;

	}
	else {
		switch (a)
		{
		case 'N':
		case 'n':
			if (pLoc->pNorth != 0) {
				pLoc = pLoc->pNorth;
				cout << "\nYou moved to the north." << endl;
				pLoc->pRoomDesc();
				}
			else {
				cout << "\nThere is no way to go that direction." << endl;
			}
			break;
		case 'E':
		case 'e':
			if (pLoc->pEast != 0) {
				pLoc = pLoc->pEast;
				cout << "\nYou moved to the east." << endl;
				pLoc->pRoomDesc();
			}
			else {
				cout << "\nThere is no way to go that direction." << endl;
			}
			break;
		case 'S':
		case 's':
			if (pLoc->pSouth != 0) {
				if (pLoc->pSouth->isLocked()) {
					cout << "\nThe door is locked. You need a Key to get in." << endl;
					if (find(inventory.begin(), inventory.end(), "Key") != inventory.end()) {
						cout << "\nThe Key you have seems like it might fit the lock." << endl;

						cin.ignore();
						getline(cin, key);
						while (key != "Use Key") {
							cout << "\nYou have a feeling you should Use Key." << endl;

							getline(cin, key);
						}
						pLoc->setLocked(false);
						cout << "\nThe door opens with the key." << endl;
						pLoc = pLoc->pSouth;
						pLoc->pRoomDesc();
					}
					else {
						cout << "\nYou do not posses a key. Try to come back if you find one." << endl;
					}
				}
				else {
					pLoc = pLoc->pSouth;
					cout << "\nYou moved to the south." << endl;
					pLoc->pRoomDesc();
				}
			}
			else {
				cout << "\nThere is no way to go that direction." << endl;
			}

			break;
		case 'W':
		case 'w':
			if (pLoc->pWest != 0) {
				pLoc = pLoc->pWest;
				cout << "\nYou moved to the west." << endl;
				pLoc->pRoomDesc();
			}
			else {
				cout << "\nThere is no way to go that direction." << endl;
			}
			break;
		default:
			break;
		}
	}
}

//Fight actions
void Player::letsFight() {

	string action;


	if (armed) {
		if (pLoc->roomEnemy.empty()) {
			cout << "\nThere is nothing to fight right now." << endl;
		}
		else if (pLoc->roomEnemy == "dog") {
			cout << "\nYou narrowly dodge out of the way as the creature lunges at you. As it passes you, you stab it deeply in the neck. \nPutting the full force of your body behind it, you slowly feel the dog like creature stop moving beneath you." << endl;
			pLoc->roomEnemy.clear();
			pLoc->pRoomDesc();
		}
		else if (pLoc->roomEnemy == "guard") {
			cout << "\nYou catch the guard by surprise, bringing your sword up and slashing across their chest, you bite deep into their flesh. \nYou see the guards eyes go lifeless as they fall to the ground infront of you." << endl;
			pLoc->roomEnemy.clear();
			pLoc->pRoomDesc();
		}
		else if (pLoc->roomEnemy == "knight") {
			cout << "\nYou dodge to the left as the axe lands by your feet. You kick the knight away to get some distance. \nWhile he is disoriented, you run full force into their armor, picking them up and carrying them into the wall opposite you. \nYou use this opportunity to stab into the soft parts of the armor. The knight makes to move but you keep stabbing repeatedly. Until finally the axe falls to the floor in a loud clang." << endl;
			pLoc->roomEnemy.clear();
			pLoc->pRoomDesc();
		}
		else if (pLoc->roomEnemy == "dHunter") {
			if (protect) {
				cout << "\nYou have but mere moments to respond!" << endl;
				cin >> action;
				while (action != "Block") {
					cout << "\nYou feel this would be a good time to use your shield to Block." << endl;
					cin >> action;
				}
				cout << "\nThe hunter moves like a shadow, but you manage to get your shield up in time. \nThe hit knocks you both back as some magical force seems to errupt from the shield. You feel this is a critical moment." << endl;
			}
			else {
				cout << "\nThe hunter moves like a shadow, you lift up your sword to block it but you know you have no chance. As the scythe hits your sword it shatters it as the scythe continues, cleaving you in two." << endl;
				cout << "\nYou have lost to the hunter, as the dark takes you, you feel something pulling at your soul. You wake up in a bed with a familiar ceiling" << endl;
				pLoc = mStart;
				inventory.clear();
				setArmed(false);
				setProtected(false);
				setSpell(false);

				resetRoomStates(mStart);
				return;
			}

			if (spell) {
				cout << "\nYou feel a warmth from the Gem you picked up earlier, a voice whispers from the dark, telling you to use it." << endl;
				cin.ignore();
				getline(cin, action);
				while (action != "Use Gem") {
					cout << "\nYou feel this would be a good time to Use Gem." << endl;
					getline(cin, action);
				}
				cout << "\nYou pull the Gem out of you pocket and smash it on the ground. Bright streams of light errupt, enveloping the dark hunter, holding them in place. This is the moment you needed." << endl;
			}
			else {
				cout << "\nYou look up and the hunter is gone, suddenly you feel a heat from your center. \nYou look down and see the tip of a scythe protruding from your chest. You cry out as the darkness takes you." << endl;
				cout << "\nYou have lost to the hunter, as the dark takes you, you feel something pulling at your soul. You wake up in a bed with a familiar ceiling" << endl;
				pLoc = mStart;
				inventory.clear();
				setArmed(false);
				setProtected(false);
				setSpell(false);

				resetRoomStates(mStart);
				return;
			}

			cin >> action;
			while (action != "Attack") {
				cout << "\nThe hunter is held in place by some magical force, but you don't know for how long. Now is the time to Attack." << endl;
				cin >> action;
			}

			cout << "\nYou use the opportunity given to you to rush towards the dark hunter. \nAs you near him you reach back and make a mighty slash, clearing his head from his body. \nBefore it ever touches the ground the hunter disipates into the shadows. \nYou feel as though a great weight has been lifted. You take a moment to collect yourself before stepping through the portal to whatever lies next." << endl;
			cout << "\nCongratulations, you have beaten the game! I hope you enjoyed it, and thank you for playing!" << endl;
			setGameOver(true);
			cin.ignore();
		}
	}

	else {
		if (pLoc->roomEnemy.empty()) {
			cout << "\nThere is nothing to fight right now, and you are lucky for it as you have nothing to fight with." << endl;
		}
		else if (pLoc->roomEnemy == "dog") {
			cout << "\nBefore you even know what is going on the thick teeth of the creature dig into you, tearing you in half." << endl;
			cout << "\nYou have lost to the dog like creature, as the dark takes you, you feel something pulling at your soul. You wake up in a bed with a familiar ceiling" << endl;
			pLoc = mStart;
			inventory.clear();
			setArmed(false);
			setProtected(false);
			setSpell(false);

			resetRoomStates(mStart);
		}
		else if (pLoc->roomEnemy == "guard") {
			cout << "\nThe guard lunges at you as you stare on in shock, his dagger piercing your heart. " << endl;
			cout << "\nYou have lost to the guard, as the dark takes you, you feel something pulling at your soul. You wake up in a bed with a familiar ceiling" << endl;
			pLoc = mStart;
			inventory.clear();
			setArmed(false);
			setProtected(false);
			setSpell(false);

			resetRoomStates(mStart);
		}
		else if (pLoc->roomEnemy == "knight") {
			cout << "\nThe knights axe comes down before you even have time to think. It cleaves you in two." << endl;
			cout << "\nYou have lost to the knight, as the dark takes you, you feel something pulling at your soul. You wake up in a bed with a familiar ceiling" << endl;
			pLoc = mStart;
			inventory.clear();
			setArmed(false);
			setProtected(false);
			setSpell(false);

			resetRoomStates(mStart);
		}
		else if (pLoc->roomEnemy == "dHunter") {
			cout << "\nThe hunter moves like a shadow, you have no chance unarmed as you are. The scythe clears through your body like paper. Your last thoughts of the freedom you almost acquired." << endl;
			cout << "\nYou have lost to the hunter, as the dark takes you, you feel something pulling at your soul. You wake up in a bed with a familiar ceiling" << endl;
			pLoc = mStart;
			inventory.clear();
			setArmed(false);
			setProtected(false);
			setSpell(false);

			resetRoomStates(mStart);
		}
	}
}

//Player pickup item
void Player::pickup() {
	if (pLoc->roomInventory.size() != 0) {
		cout << "\nItems available to pick up:" << endl;
		pLoc->getRoomItems();

		string item;
		cout << "\nEnter the item you want to pick up: ";
		cin >> item;

		vector<string>::iterator iter;
		iter = find(pLoc->roomInventory.begin(), pLoc->roomInventory.end(), item);

		if (iter != pLoc->roomInventory.end()) {
			inventory.push_back(item);
			pLoc->roomInventory.erase(iter);
			cout << "You picked up " << item << "." << endl;
			if (item == "Sword") {
				setArmed(true);
			}
			else if (item == "Shield") {
				setProtected(true);
			}
			else if (item == "Gem") {
				setSpell(true);
			}
		}
		else {
			cout << "Item not found in this room." << endl;
		}
	}
	else {
		cout << "There are no items to pick up in this room." << endl;
	}
}

//Drop an item in the room you are in
void Player::dropIt() {
	if (inventory.size() != 0) {
		cout << "\nItems available to drop:" << endl;
		getInventory();

		string item;
		cout << "\nEnter the item you want to drop: ";
		cin >> item;

		vector<string>::iterator iter;
		iter = find(inventory.begin(), inventory.end(), item);

		if (iter != inventory.end()) {
			pLoc->roomInventory.push_back(item);
			inventory.erase(iter);
			cout << "You dropped " << item << "." << endl;
			if (item == "Sword") {
				setArmed(false);
			}
			else if (item == "Shield") {
				setProtected(false);
			}
			else if (item == "Gem") {
				setSpell(false);
			}
		}
		else {
			cout << "Item not found in Inventory." << endl;
		}
	}
	else {
		cout << "There are no items to drop." << endl;
	}
}

//Talk to the women in the cell
void Player::letsTalk() {
	if (pLoc->rDesc == "\nAs you enter the room, you see 4 cells. \nThey are mostly empty, save for the one in the back. \nYou notice a figure sitting on the bed. The door to the West, where you came in is the only exit." || pLoc->rDesc2 == "\nAs you reenter the cells the woman is sitting and waiting. \nThe door to the East, where you came in is the only exit.") {
		cout << "\nYou greet the woman. She looks up at you. \nYou still cannot see he face but she says to you \"It is good to see another face again. I must warn you this is a prison like no other. \nYou shall find no easy escape. However if you find the Sword, Shield, and Gem, before reaching the end, you may have a chance.\"" << endl;
	}
	else {
		cout << "\nYou begin talking to yourself. Normally you'd say you are going crazy but what is crazy in a place like this." << endl;
	}
}

//Reset rooms on death
void Player::resetRoomStates(Room* room) {
	if (room) {
		room->setVisited(false);
		room->setLocked(true);
		resetRoomStates(room->pNorth);
		resetRoomStates(room->pEast);
		resetRoomStates(room->pSouth);
		resetRoomStates(room->pWest);
	}
}